/*
 * The org.opensourcephysics.tools package defines classes for managing OSP
 * applications and objects.
 */
package org.opensourcephysics.tools;

import java.rmi.*;
import java.rmi.server.*;

/**
 * This is a Remote Job implementation for osp data transfers via RMI.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class RemoteJob
    extends UnicastRemoteObject
    implements Job {

  // instance fields
  Job wrappedJob;

  /**
   * Constructs a RemoteJob that wraps a source job.
   *
   * @param job the LocalJob
   * @throws RemoteException if object cannot be constructed
   */
  public RemoteJob(Job job) throws RemoteException {
    wrappedJob = job;
  }

  /**
   * Gets the xml string.
   *
   * @return the xml string
   * @throws RemoteException
   */
  public String getXML() throws RemoteException {
    return wrappedJob.getXML();
  }

  /**
   * Sets the xml string.
   *
   * @param xml the xml string
   * @throws RemoteException
   */
  public void setXML(String xml) throws RemoteException {
    wrappedJob.setXML(xml);
  }

}
