/*
 * The org.opensourcephysics.tools package defines classes for managing OSP
 * applications and objects.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.controls.*;

/**
 * This is a Job implementation for osp data transfers within a single vm.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class LocalJob implements Job {

  // instance fields
  String xml;

  /**
   * Constructs a LocalJob.
   */
  public LocalJob() {
    setXML(new Object());
  }

  /**
   * Constructs a LocalJob with a specified xml string.
   *
   * @param xml the string
   */
  public LocalJob(String xml) {
    setXML(xml);
  }

  /**
   * Constructs a LocalJob for a specified object.
   *
   * @param obj the object
   */
  public LocalJob(Object obj) {
    setXML(obj);
  }

  /**
   * Gets the xml string. Implements Job.
   *
   * @return the xml string
   */
  public String getXML() {
    return xml;
  }

  /**
   * Sets the xml string. Implements Job.
   *
   * @param xml the xml string
   */
  public void setXML(String xml) {
    if (xml != null) {
      this.xml = xml;
    }
  }

  /**
   * Sets the xml string to that saved by the specified object.
   *
   * @param obj the object
   */
  public void setXML(Object obj) {
    XMLControl control = new XMLControlElement(obj);
    setXML(control.toXML());
  }

}
