/*
 * The org.opensourcephysics.tools package defines classes for managing OSP
 * applications and objects.
 */
package org.opensourcephysics.tools;

import java.rmi.*;

/**
 * This is a Remote interface for osp data transfers via XML and RMI.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public interface Job extends Remote {

  /**
   * Gets the xml string.
   *
   * @return the xml string
   * @throws RemoteException
   */
  public String getXML() throws RemoteException;

  /**
   * Sets the xml string.
   *
   * @param xml the xml string
   * @throws RemoteException
   */
  public void setXML(String xml) throws RemoteException;

}
