package org.opensourcephysics.tools;

import java.io.File;
import java.util.List;
import org.opensourcephysics.controls.XMLControl;
import java.util.Iterator;
import org.opensourcephysics.controls.XMLControlElement;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.*;
import javax.swing.JOptionPane;

/**
 * Exports data in XML format.
 *
 * @author W. Christian
 * @version 1.0
 */
public class ExportXMLFormat implements ExportFormat {
  public String description() { return "XML"; }
  public String extension() { return "xml"; }

  public void export(File file, List data) {
    FileWriter fw = null;
    try {
      fw = new FileWriter(file);
    }
    catch (IOException ex) {
      JOptionPane.showMessageDialog(null, "An error occurred while saving your file. Please try again.", "Error", JOptionPane.ERROR_MESSAGE);
      return;
    }
    PrintWriter pw = pw = new PrintWriter(fw);
    Iterator it = data.iterator();
    while (it.hasNext()) {
      XMLControl control = new XMLControlElement(it.next()); //convert the data to xml
      pw.print(control.toXML());
      pw.println();
    }
    pw.close();
  }
}
