/*
 * The org.opensourcephysics.tools package defines classes for managing OSP
 * applications and objects.
 */
package org.opensourcephysics.tools;

import java.io.*;

import java.awt.*;
import java.awt.datatransfer.*;

/**
 * This is a Job implementation for osp data transfers via the clipboard.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class ClipboardJob extends LocalJob {

  static private final Clipboard clipboard =
      Toolkit.getDefaultToolkit().getSystemClipboard();

  /**
   * Constructs a ClipboardJob.
   */
  public ClipboardJob() {
  }

  /**
   * Constructs a ClipboardJob with a specified xml string.
   *
   * @param xml the string
   */
  public ClipboardJob(String xml) {
    super(xml);
  }

  /**
   * Constructs a ClipboardJob for a specified object.
   *
   * @param obj the object
   */
  public ClipboardJob(Object obj) {
    super(obj);
  }

  /**
   * Gets the xml string. Implements Job.
   *
   * @return the xml string
   */
  public String getXML() {
      // this is the paste function
      try {
        Transferable data = clipboard.getContents(null);
        return (String)data.getTransferData(DataFlavor.stringFlavor);
      } catch(UnsupportedFlavorException ex) {}
      catch(IOException ex) {}
      catch(HeadlessException ex) {}
      return null;
  }

  /**
   * Sets the xml string. Implements Job.
   *
   * @param xml the xml string
   */
  public void setXML(String xml) {
      // this is the copy function
      if (xml != null) {
        StringSelection data = new StringSelection(xml);
        clipboard.setContents(data, data);
      }
  }

}
