/*
 * The org.opensourcephysics.tools package defines classes for managing OSP
 * applications and objects.
 */
package org.opensourcephysics.tools;

import javax.swing.table.AbstractTableModel;

/**
 * A table model for an ArrayTable.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class ArrayTableModel extends AbstractTableModel{

  // instance fields
  double[] doubleArray1;
  double[][] doubleArray2;
  int[] intArray1;
  int[][] intArray2;

  public ArrayTableModel(int[] array) {
    intArray1 = array;
  }

  public ArrayTableModel(int[][] array) {
    intArray2 = array;
  }

  public ArrayTableModel(double[] array) {
    doubleArray1 = array;
  }

  public ArrayTableModel(double[][] array) {
    doubleArray2 = array;
  }

  /**
   * Gets the number of columns.
   *
   * @return the column count
   */
  public int getColumnCount() {
    if (getRowCount() == 0) return 0;
    if (intArray1 != null) return 2;
    if (intArray2 != null) return intArray2[0].length + 1;
    if (doubleArray1 != null) return 2;
    if (doubleArray2 != null) return doubleArray2[0].length + 1;
    return 0;
  }

  /**
   * Gets the name of the specified column.
   *
   * @param column the column index
   * @return the column name
   */
  public String getColumnName(int column) {
    if (column == 0) return "";
    if (intArray1 != null || doubleArray1 != null) return "value";
    return "" + (column-1);
  }


  /**
   * Gets the number of rows.
   *
   * @return the row count
   */
  public int getRowCount() {
    if (intArray1 != null) return intArray1.length;
    if (intArray2 != null) return intArray2.length;
    if (doubleArray1 != null) return doubleArray1.length;
    if (doubleArray2 != null) return doubleArray2.length;
    return 0;
  }

  /**
   * Gets the value at the given cell.
   *
   * @param row the row index
   * @param column the column index
   * @return the value
   */
  public Object getValueAt(int row, int column) {
    if (column == 0) return new Integer(row);
    if (intArray1 != null) {
      return new Integer(intArray1[row]);
    }
    if (intArray2 != null) {
      return new Integer(intArray2[row][column-1]);
    }
    if (doubleArray1 != null) {
      return new Double(doubleArray1[row]);
    }
    if (doubleArray2 != null) {
      return new Double(doubleArray2[row][column-1]);
    }
    return null;
  }

}
