/*
 * The org.opensourcephysics.tools package defines classes for managing OSP
 * applications and objects.
 */
package org.opensourcephysics.tools;

import javax.swing.*;
import java.awt.*;
import javax.swing.event.*;

/**
 * A dialog that displays an array table.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class ArrayInspector extends JDialog {

  // instance fields
  JTabbedPane tabbedPane= new JTabbedPane();
  ArrayTable[] tables;
  JSpinner spinner;
  JScrollPane scrollpane;

  private ArrayInspector() {
    super((Frame)null, true);
  }


  public ArrayInspector(int[] array) {
    this();
    tables = new ArrayTable[1];
    tables[0] = new ArrayTable(array);
    createGUI();
    setTitle("Array: int[row]");
  }

  public ArrayInspector(int[] array, String arrayName) {
    this(array);
    setTitle("Array \"" + arrayName + "\": int[row]");
  }

  public ArrayInspector(int[][] array) {
    this();
    tables = new ArrayTable[1];
    tables[0] = new ArrayTable(array);
    createGUI();
    setTitle("Array: int[row][column]");
  }

  public ArrayInspector(int[][] array, String arrayName) {
    this(array);
    setTitle("Array \"" + arrayName + "\": int[row][column]");
  }

  public ArrayInspector(int[][][] array) {
    this();
    tables = new ArrayTable[array.length];
    for (int i = 0; i < tables.length; i++) {
      tables[i] = new ArrayTable(array[i]);
    }
    createGUI();
    setTitle("Array: int[index][row][column]");
  }

  public ArrayInspector(int[][][] array, String arrayName) {
    this(array);
    setTitle("Array \"" + arrayName + "\": int[index][row][column]");
  }

  public ArrayInspector(double[] array) {
    this();
    tables = new ArrayTable[1];
    tables[0] = new ArrayTable(array);
    createGUI();
    setTitle("Array: double[row]");
  }

  public ArrayInspector(double[] array, String arrayName) {
    this(array);
    setTitle("Array \"" + arrayName + "\": double[row]");
  }

  public ArrayInspector(double[][] array) {
    this();
    tables = new ArrayTable[1];
    tables[0] = new ArrayTable(array);
    createGUI();
    setTitle("Array: double[row][column]");
  }

  public ArrayInspector(double[][] array, String arrayName) {
    this(array);
    setTitle("Array \"" + arrayName + "\": double[row][column]");
  }

  public ArrayInspector(double[][][] array) {
    this();
    tables = new ArrayTable[array.length];
    for (int i = 0; i < tables.length; i++) {
      tables[i] = new ArrayTable(array[i]);
    }
    createGUI();
    setTitle("Array: double[index][row][column]");
  }

  public ArrayInspector(double[][][] array, String arrayName) {
    this(array);
    setTitle("Array \"" + arrayName + "\": double[index][row][column]");
  }

  public void createGUI() {
    setSize(400,300);
    setContentPane(new JPanel(new BorderLayout()));
    scrollpane = new JScrollPane(tables[0]);
    if (tables.length > 1) {
      // create spinner
      SpinnerModel model = new SpinnerNumberModel(0, 0, tables.length-1, 1);
      spinner = new JSpinner(model);
      JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner);
      editor.getTextField().setFont(tables[0].indexRenderer.getFont());
      spinner.setEditor(editor);
      spinner.addChangeListener(new ChangeListener() {
        public void stateChanged(ChangeEvent e) {
          int i = ((Integer)spinner.getValue()).intValue();
          scrollpane.setViewportView(tables[i]);
         }
      });
      Dimension dim = spinner.getMinimumSize();
      spinner.setMaximumSize(dim);
      getContentPane().add(scrollpane, BorderLayout.CENTER);
      JToolBar toolbar = new JToolBar();
      toolbar.setFloatable(false);
      toolbar.add(new JLabel(" index "));
      toolbar.add(spinner);
      toolbar.add(Box.createHorizontalGlue());
      getContentPane().add(toolbar, BorderLayout.NORTH);
    }
    else {
      JScrollPane scrollpane = new JScrollPane(tables[0]);
      scrollpane.createHorizontalScrollBar();
      getContentPane().add(scrollpane,BorderLayout.CENTER);
    }
  }

  public void refreshTable(){
    for (int i = 0; i < tables.length; i++){
      tables[i].refreshTable();
    }
  }

}
