package org.opensourcephysics.numerics;

/**
 * Transformation maps coordinates from one coordinate system to another.
 */
public interface Transformation extends Cloneable {

  /**
   * Provides a copy of this transformation.
   * This is used by a Body that will explicitely get a clone of
   * it whenever its setTransformation() method is invoked.
   * Thus, changing the original transformation directly
   * has no effect unless a new setTransformation is invoked.
   */
  public Object clone ();

  /**
   * Transforms a given point
   * @param point the double[] coordinates to be transformed
   * (the array's contents will be changed accordingly)
   */
  public void direct (double[] point);

  /**
   * The inverse transformation (if it exists).
   * If the transformation is not invertible, then a call to this
   * method must throw a UnsupportedOperationException exception.
   * @param point the double[] coordinates to be transformed
   * (the array's contents will be changed accordingly)
   */
  public void inverse (double[] point) throws UnsupportedOperationException;

}
