/*
 * The org.opensourcephysics.numerics package contains numerical methods
 * for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.numerics;

/**
 * ODEAdaptiveSolver extends the ODE solver to add adaptive step size capabilities.
 *
 * Adaptive ODE solvers adjust the step size until that the desired tolerance is reached.
 *
 * The client's state can effect the internal state of the ODE solver. Some adaptive solvers
 * advance an internal copy of client's state.  This internal state is then copied to the client after
 * every step.  Other solvers estimate the optimal time step using the client's state. Clients
 * should therfore always invoke the solver's initialize method after setting their initial conditions.
 *
 * @author       Wolfgang Christian
 */

public interface ODEAdaptiveSolver extends ODESolver {
  /**
   * Sets the tolerance of the adaptive ODE sovler.
   * @param tol the tolerance
   */
  public void setTolerance(double tol);
  /**
   * Gets the tolerance of the adaptive ODE sovler.
   * @return
   */
  public double  getTolerance();

}
