/*
 * The org.opensourcephysics.numerics package contains numerical methods
 * for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.numerics;

/**
 * Indicates that an error occured in a numeric method.
 */
public final class NumericMethodException extends RuntimeException {

 /** Field error_value stores an optional numeric error.  */
  public double error_value;

  /** Field error_code sotes an optional error code       */
  public int    error_code;

  /**
   * Constructs a <code>RuntimeException</code> with no detail  message.
     */
  public NumericMethodException() {
    super();
  }

  /**
   * Constructs a <code>RuntimeException</code> with the specified
   * detail message.
   *
   * @param   s   the detail message.
     */
  public NumericMethodException(String msg) {
    super(msg);
  }

  /**
   * Constructs a <code>RuntimeException</code> with the specified
   * detail message, error code, and error estimate.
   *
   * @param msg
   * @param code
   * @param val
   */
  public NumericMethodException(String msg, int code, double val) {
    super(msg);
    error_code  = code;
    error_value = val;
  }

  /**
   * Returns the error message string of this throwable object.
   *
   *
   */
  public String getMessage() {
    return super.getMessage()+"\n error code="+error_code+ "  error value="+error_value;
  }
}
