/*
 * The org.opensourcephysics.numerics package contains numerical methods
 * for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.numerics;

/**
 * MathExpParser defines an abstract super class for mathematical expression parsers.
 */
public abstract class MathExpParser implements Function, MultiVarFunction{

  /** No error. */
  public   static final int NO_ERROR             =  0;
  /**  Syntax error. */
  public   static final int SYNTAX_ERROR         =  1;

  /**
   * Parses the function string using existing variable names.
   *
   * @param funcStr the function to be parsed
   */
  public abstract void setFunction(String funcStr)  throws ParserException ;

  /**
   * Parses the function string using existing variable names.
   *
   * @param funcStr the function to be parsed
   * @param vars the function's variables
   */
  public abstract void setFunction(String funcStr, String[] vars)  throws ParserException ;

  /**
   * Gets the function string.
   */
  public abstract String getFunction();
}
