/*
 * The org.opensourcephysics.numerics package contains numerical methods
 * for the book Simulations in Physics.
 * Copyright (c) 2002  H. Gould, J. Tobochnik, and W. Christian.
 */

package org.opensourcephysics.numerics;

public final class LogBase10Function implements InvertibleFunction {
        static double log10 = Math.log(10);

        public double evaluate(double x) {
                return  Math.log(x)/log10;
        }

        public double getInverse(double y) {
                return Math.pow(10,y);
        }

}