package org.opensourcephysics.numerics;

/**
 * Euler implements an Euler method ODE solver.
 *
 * The Euler method is unstable for many systems.  It is included as an  example of
 * how to use the ODE and ODESolver interface.
 *
 * @author       Wolfgang Christian
 * @version 1.0
 */
public class Euler extends AbstractODE {

  /**
   * Constructs the Euler ODESolver for a system of ordinary differential equations.
   *
   * @param ode the system of differential equations.
   */
   public Euler(ODE ode) {
      super(ode);
   }

  /**
   * Steps (advances) the differential equations by the stepSize.
   *
   * The ODESolver invokes the ODE's getRate method to obtain the initial state of the system.
   * The ODESolver then advances the solution and copies the new state into the
   * state array at the end of the solution step.
   *
   * @return the step size
   */
   public double step() {
      double[] state = ode.getState();
      ode.getRate(state, rate);
      for (int i = 0; i < numEqn; i++) {
         state[i] = state[i] + stepSize * rate[i];
      }
      return stepSize;
   }
}

