package org.opensourcephysics.frames;
import org.opensourcephysics.display.*;

public class TableFrame extends DataTableFrame {

   TableData tableData = new TableData();

   /**
    * Constructs a TableFrame with the given title.
    * @param frameTitle String
    */
   public TableFrame(String frameTitle){
      super(frameTitle, new DataTable());
      setAnimated(true);
      setAutoclear(true);
      table.setModel(tableData);
      setRowNumberVisible(true);
   }

   /**
    *  Sets the display row number flag. Table displays row number.
    *
    * @param  vis  <code>true<\code> if table display row number
    */
   public void setRowNumberVisible(boolean vis){
      table.setRowNumberVisible(vis);
      tableData.setRowNumberVisible(vis);
   }

   /**
    * Appends a row of data with the given values to the table.
    * @param x double[]
    */
   public synchronized void appendRow(double[] x) {
      tableData.append(x);
      if(isShowing()) {
         table.refreshTable();
      }
   }

   /**
    * Appends a row of data with the given values to the table.
    * @param x double[]
    */
   public synchronized void appendRow(int[] x){
      tableData.append(x);
      if (isShowing()){
         table.refreshTable();
      }
   }

   /**
    * Appends a row of data with the given values to the table.
    * @param x double[]
    */
   public synchronized void appendRow(String[] x){
      tableData.append(x);
      if (isShowing()){
         table.refreshTable();
      }
   }

   /**
    * Appends a row of data with the given values to the table.
    * @param x double[]
    */
   public synchronized void appendRow(byte[] x){
      tableData.append(x);
      if (isShowing()){
         table.refreshTable();
      }
   }



   /**
    *  Sets the column names in a JTable.
    *
    * @param  column  the index
    * @param  name
    */
   public void setColumnNames(int column, String name){
      tableData.setColumnNames(column, name);
   }


   /**
    * Shows or hides this TableFrame depending on the value of parameter
    * <code>vis</code>.
    * @param vis  if <code>true</code>, shows this component;
    * otherwise, hides this component
    */
   public void setVisible(boolean vis) {
      if(vis) {
         table.refreshTable(); // make sure the table shows the current values
      }
      super.setVisible(vis);
   }

   /**
    * Clears data from drawing objects within this frame.
    *
    * The default method does nothing.
    * Override this method to select the object(s) and the data to be cleared.
    */
   public synchronized void clearData() {
      tableData.list.clear();
      tableData.colCount = 0;
   }

}
