package org.opensourcephysics.frames;

import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;


/**
 * A table model for this frame.
 *
 * @author Wolfgang Christian
 * @version 1.0
 */
 public class TableData extends AbstractTableModel{

  ArrayList list= new ArrayList();
  ArrayList names= new ArrayList();
  boolean rowNumberVisible=true;
  int colCount=0;

  public TableData() {
  }

  public void append(double[] x) {
    double[] row;
    if (x == null) {
      return;
    }
    row = new double[x.length];
    System.arraycopy(x, 0, row, 0, x.length);
    list.add(row);
    colCount = Math.max(colCount, row.length+1);
  }

  public void append(int[] x){
     int[] row;
     if (x==null){
        return;
     }
     row = new int[x.length];
     System.arraycopy(x, 0, row, 0, x.length);
     list.add(row);
     colCount = Math.max(colCount, row.length+1);
  }

  public void append(byte[] x){
     byte[] row;
     if (x==null){
        return;
     }
     row = new byte[x.length];
     System.arraycopy(x, 0, row, 0, x.length);
     list.add(row);
     colCount = Math.max(colCount, row.length+1);
  }


  public void append(String[] x) {
    String[] row;
    if (x == null) {
      return;
    }
    row = new String[x.length];
    System.arraycopy(x, 0, row, 0, x.length);
    list.add(row);
    colCount = Math.max(colCount, row.length+1);
  }

  /**
   *  Sets the display row number flag. Table displays row number.
   *
   * @param  vis  <code>true<\code> if table display row number
   */
  public void setRowNumberVisible(boolean vis){
     rowNumberVisible=vis;
  }


  /**
   *  Sets the column names in a JTable.
   *
   * @param  column  the column index
   * @param  name
   */
  public void setColumnNames(int column, String name){
    while(column>=names.size()){
       names.add(""+(char)('A'+column));
    }
    names.set(column,name);
  }



  /**
   * Gets the number of columns.
   *
   * @return the column count
   */
  public int getColumnCount() {
    if (getRowCount() == 0) return 0;
    return (rowNumberVisible)?colCount:colCount-1;
  }

  /**
   * Gets the name of the specified column.
   *
   * @param column the column index
   * @return the column name
   */
  public String getColumnName(int column) {
    if( column==0 && rowNumberVisible) return "row #";
    if(!rowNumberVisible)column++;
    if(column <= names.size()){
       return (String) names.get(column-1);
    }
    return ""+(char)('A'+column);
  }


  /**
   * Gets the number of rows.
   *
   * @return the row count
   */
  public int getRowCount() {
    return list.size();
  }

  /**
   * Gets the value at the given cell.
   *
   * @param row the row index
   * @param column the column index
   * @return the value
   */
  public Object getValueAt(int row, int column) {
    if (column == 0 && rowNumberVisible) return new Integer(row);
    if(!rowNumberVisible)column++;
    if(row>=list.size()) return "";
    Object r=list.get(row);
    if(!r.getClass().isArray() ) return "";
    if (r instanceof double[]){
       double[] array = (double[]) r;
       if (column>array.length)return "";
       return new Double(array[column-1]);
    }
    if (r instanceof byte[]){
       byte[] array = (byte[]) r;
       if (column>array.length)return "";
       return new Byte(array[column-1]);
    }
    if (r instanceof int[]){
       int[] array = (int[]) r;
       if (column>array.length)return "";
       return new Integer(array[column-1]);
    }
    if (r instanceof String[]){
       String[] array = (String[]) r;
       if (column>array.length)return "";
       return array[column-1];
    }
    return "";
  }

}
