package org.opensourcephysics.frames;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.PlottingPanel;

/**
 * A DrawingFrame with an empty drawing panel.
 *
 * Programs should add drawables to this frame using the addDrawable method.
 * ClearData removes all drawables from this frame.
 *
 * @author W. Christian
 * @version 1.0
 */
public class DisplayFrame extends DrawingFrame {

  /**
   * Constructs the DisplayFrame with the given title.
   *
   * @param title String
   */
  public DisplayFrame(String title) {
    super(new InteractivePanel());
    setTitle(title);
    setAnimated(true);
    setAutoclear(true);
    drawingPanel.setSquareAspect(true);  // objects retain their shape
  }

  /**
 * Constructs the DisplayFrame with the given labels and title.
 *
 * @param xlabel String
 * @param ylabel String
 * @param title String
 */
public DisplayFrame(String xlabel, String ylabel, String title) {
  super(new PlottingPanel(xlabel, ylabel, null));
  setTitle(title);
  setAnimated(true);
  setAutoclear(true);
  drawingPanel.setSquareAspect(true);  // objects retain their shape
}

}
