package org.opensourcephysics.frames;
import org.opensourcephysics.display3d.simple3d.DrawingFrame3D;
import org.opensourcephysics.display3d.simple3d.DrawingPanel3D;
import org.opensourcephysics.display3d.core.Element;
import javax.swing.*;
import org.opensourcephysics.display.OSPLayout;
import java.awt.BorderLayout;
import org.opensourcephysics.display.TextPanel;

public class Display3DFrame extends DrawingFrame3D {

   JPanel glassPanel = new JPanel();
   protected TextPanel trMessageBox = new TextPanel();                         // text box in top right hand corner for message
   protected TextPanel tlMessageBox = new TextPanel();                         // text box in top left hand corner for message
   protected TextPanel brMessageBox = new TextPanel();                         // text box in lower right hand corner for message
   protected TextPanel blMessageBox = new TextPanel();                         // text box in lower left hand corner for mouse coordinates


   public Display3DFrame(String title) {
      super(title, new DrawingPanel3D());
      glassPanel.setLayout(new OSPLayout());
      glassPanel.add(trMessageBox, OSPLayout.TOP_RIGHT_CORNER);
      glassPanel.add(tlMessageBox, OSPLayout.TOP_LEFT_CORNER);
      glassPanel.add(brMessageBox, OSPLayout.BOTTOM_RIGHT_CORNER);
      glassPanel.add(blMessageBox, OSPLayout.BOTTOM_LEFT_CORNER);
      glassPanel.setOpaque(false);
      glassPanel.setVisible(true);
      drawingPanel.getJPanel().setLayout(new BorderLayout());
      drawingPanel.getJPanel().add(glassPanel, BorderLayout.CENTER);
      setAnimated(true);
   }

   /**
    * Set the extrema in the X, Y and Z coordinates at once
    *
    * @param xmin double
    * @param xmax double
    * @param ymin double
    * @param ymax double
    * @param zmin double
    * @param zmax double
    */
   public void setPreferredMinMax(double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
      drawingPanel.setPreferredMinMax(xmin, xmax, ymin, ymax, zmin, zmax);
   }

   public void render(){
      drawingPanel.updatePanel();
      glassPanel.repaint();
   }

   /**
    * Adds an Element to this DrawingPanel3D.
    * @param element Element
    * @see Element
    */
   public void addElement(Element element) {
      drawingPanel.addElement(element);
   }

   /**
    * Whether the panel should try to keep a square aspect.
    * Default value is true.
    * @param square boolean
    */
   public void setSquareAspect(boolean square){
      drawingPanel.setSquareAspect(square);
   }


   /**
    * Shows a message in a yellow text box in the lower right hand corner.
    *
    * @param msg
    */
   public void setMessage(String msg) {
      brMessageBox.setText(msg); // the default message box
   }

   /**
    * Shows a message in a yellow text box.
    *
    * location 0=bottom left
    * location 1=bottom right
    * location 2=top right
    * location 3=top left
    *
    * @param msg
    * @param location
    */
   public void setMessage(String msg, int location) {
      switch(location) {
         case 0 : // usually used for mouse coordiantes
            blMessageBox.setText(msg);
            break;
         case 1 :
            brMessageBox.setText(msg);
            break;
         case 2 :
            trMessageBox.setText(msg);
            break;
         case 3 :
            tlMessageBox.setText(msg);
            break;
      }
   }

   /**
    * Types of decoration displayed. One of the following
    * <ul>
    *   <li><b>VisualizationHints.DECORATION_NONE</b>: No decoration</li>
    *   <li><b>VisualizationHints.DECORATION_AXES</b>: Display labelled axes</li>
    *   <li><b>VisualizationHints.DECORATION_CUBE</b>: Display the bounding box</li>
    * </ul>
    * @param type the desired value
    */
   public void setDecorationType(int value) {
      drawingPanel.getVisualizationHints().setDecorationType(value);
   }

   /**
    * Set the angle (in radians) to rotate the scene horizontally
    * before projecting. Default is 0.0.
    * @param _alpha the desired angle
   */
   public void setAlpha(double alpha){
      drawingPanel.getVisualizationHints().setAlpha(alpha);
   }

   /**
 * Set the angle (in radians) to rotate the scene vertically
 * before projecting. Default is 0.0.
 * @param _beta the desired angle
 */
   public void setBeta(double beta){
      drawingPanel.getVisualizationHints().setBeta(beta);
   }



   /**
    * The display mode for the panel. One of the following
    * <ul>
    *   <li><b>VisualizationHints.DISPLAY_PERSPECTIVE</b>: 3D view with perspective. The default.</li>
    *   <li><b>VisualizationHints.DISPLAY_NO_PERSPECTIVE</b>: 3D view with no perspective.</li>
    *   <li><b>VisualizationHints.DISPLAY_XY</b>: 2D view using X and Y coordinates.</li>
    *   <li><b>VisualizationHints.DISPLAY_XZ</b>: 2D view using X and Z coordinates.</li>
    *   <li><b>VisualizationHints.DISPLAY_YZ</b>: 2D view using Y and Z coordinates.</li>
    * </ul>
    * @param mode the desired value
    */
   public void setDisplayMode(int mode) {
      drawingPanel.getVisualizationHints().setDisplayMode(mode);
   }
}
