/*
 * The value package contains utilities to work with primitives
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.value;

 /**
  * @see     Value
  */

public class ObjectValue extends Value {
  public Object value;

  public ObjectValue (Object _val) { value = _val; }

  public boolean getBoolean() { return value.toString().equals("true"); }

  public int getInteger() {
    return (int) Math.round(getDouble());
  }

  public double  getDouble()  {
    try { return Double.valueOf(value.toString()).doubleValue(); }
    catch (NumberFormatException exc) { return 0.0; }
  }

  public String  getString()  { return value.toString(); }

  public Object  getObject()  { return value; }

//  public void copyInto (double[] array) {
//    double[] data = (double[]) value;
//    int n = data.length;
//    if (array.length<n) n = array.length;
//    System.arraycopy(data,0,array,0,n);
//  }
//
//  public void copyInto (double[][] array) {
//    double[][] data = (double[][]) value;
//    int n = data.length;
//    if (array.length<n) n = array.length;
//    for (int i=0; i<n; i++) {
//      int ni = data[i].length;
//      if (array[i].length<ni) ni = array[i].length;
//      System.arraycopy(data[i],0,array[i],0,ni);
//    }
//  }

}

