/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

//import org.opensourcephysics.ejs.control.ControlElement;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import org.opensourcephysics.ejs.control.value.Value;

/**
 * A configurable text. It has no internal value, nor can trigger
 * any action.
 */
public class ControlTextArea extends ControlSwingElement {
  static String _RETURN_ = System.getProperty("line.separator");

  protected JTextArea textarea;
  private javax.swing.JScrollPane panel;
  private TitledBorder titledBorder;
  private EtchedBorder etchedBorder;

// ------------------------------------------------
// Visual component
// ------------------------------------------------
  public ControlTextArea (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) {
    if (_visual instanceof JTextArea) textarea = (JTextArea) _visual;
    else {
      textarea = new JTextArea(5, 5);
      textarea.setEditable(false);
    }
    panel = new javax.swing.JScrollPane(textarea);
    etchedBorder = new EtchedBorder(EtchedBorder.LOWERED);
    titledBorder = new TitledBorder (etchedBorder,"");
    titledBorder.setTitleJustification (TitledBorder.CENTER);
    panel.setBorder (etchedBorder);
    return textarea;
  }

  public java.awt.Component getComponent () { return panel; }

  public void reset () { textarea.setText(""); }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("title");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("title"))          return "String";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : // title
        if (!_value.getString().equals(titledBorder.getTitle())) {
          titledBorder.setTitle (_value.getString());
          panel.setBorder (titledBorder);
          panel.repaint();
        }
        break;
      default: super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : // title
        panel.setBorder (etchedBorder);
        panel.repaint();
        break;
      default: super.setDefaultValue(_index-1); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 :
        return null;
      default: return super.getValue(_index-1);
    }
  }

// ------------------------------------------------
// Output
// ------------------------------------------------

  public void clear () {
    textarea.setText("");
    textarea.setCaretPosition (textarea.getText().length());
  }

  public void println (String s) { print (s+_RETURN_); }

  public void print (String s) {
    textarea.append(s);
    textarea.setCaretPosition (textarea.getText().length());
  }

} // End of class