/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import javax.swing.JTabbedPane;

import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * A configurabel TabbedPanel
 */
public class ControlTabbedPanel extends ControlContainer {
  protected JTabbedPane tabbedpanel;

// ------------------------------------------------
// Visual component
// ------------------------------------------------
  public ControlTabbedPanel (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) {
    if (_visual instanceof JTabbedPane) tabbedpanel = (JTabbedPane) _visual;
    else tabbedpanel=new JTabbedPane (JTabbedPane.TOP);
    return tabbedpanel;
  }

  public void add(ControlElement _child) {
    String header = _child.getProperty("name");
    if (header!=null) tabbedpanel.add(_child.getComponent(),header);
    else tabbedpanel.add(_child.getComponent(),"   ");
    if (_child instanceof ControlRadioButton) {
      radioButtons.add(_child);
      ((ControlRadioButton)_child).setParent(this);
    }
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("placement");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("placement"))    return "Placement|int";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 :
        if (tabbedpanel.getTabPlacement()!=_value.getInteger()) tabbedpanel.setTabPlacement(_value.getInteger());
        break;
      default: super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : tabbedpanel.setTabPlacement(javax.swing.SwingConstants.TOP); break;
      default: super.setDefaultValue(_index-1); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 :
        return null;
      default: return super.getValue(_index-1);
    }
  }


} // End of class



