/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import java.applet.Applet;
import java.applet.AudioClip;

import org.opensourcephysics.ejs.control.value.Value;

/**
 * An element to play sound according to the state of an internal
 * variable. The element does not change this variable
 */
public class ControlSound extends ControlCheckBox {
  static final int VARIABLE  = ControlCheckBox.VARIABLE+1;

  private AudioClip clip=null;
  private String audioFile = null;
  private boolean playing=false;

  public ControlSound (Object _visual) {
    super (_visual);
    checkbox.addActionListener (
      new java.awt.event.ActionListener() {
        public void actionPerformed (java.awt.event.ActionEvent _e) {
          if (checkbox.isSelected()) play();
          else stop();
        }
      }
    );
  }

  public void setAudioClip(String _codebase, String _audioFile) {
    if (_audioFile==null) { stop(); clip = null; return; }
    try {
      String prefix="";
      if (_codebase==null) prefix = "file:";
      else {
        prefix = _codebase.toString();
        if (prefix.startsWith("file:")) prefix = "file:///"+ prefix.substring(6);
        if (!prefix.endsWith("/")) prefix += "/";
      }
      String filename = prefix + _audioFile;
      java.net.URL url =  new java.net.URL(filename);
      clip = Applet.newAudioClip(url);
    }
    catch (Exception ex) { ex.printStackTrace(); clip = null; }
  }

  public void destroy() {
    if (clip!=null) clip.stop();
    clip = null;
    super.destroy();
  }

  public void play() {
    if (clip==null) return;
    clip.loop();
  }

  public void stop() { if (clip!=null) clip.stop(); }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("audiofile");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("audiofile"))      return "File|String";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : setAudioFile(_value.getString()); break; // audiofile
      case VARIABLE :
        if (_value.getBoolean()!=playing) {
          if (playing=_value.getBoolean()) play();
          else stop();
        }
        super.setValue(ControlCheckBox.VARIABLE,_value);
        break;
      default: super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : setAudioClip(null,null); audioFile = null; break;
      default: super.setDefaultValue(_index-1); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 :
        return null;
      default: return super.getValue(_index-1);
    }
  }

// -------------------------------------
// private methods
// -------------------------------------

  private void setAudioFile (String _audio) {
    if (audioFile!=null && audioFile.equals(_audio)) return; // no need to do it again
    audioFile = _audio;
    if (getProperty("_ejs_codebase")!=null) setAudioClip (getProperty("_ejs_codebase"),_audio);
    else if (getSimulation()!=null && getSimulation().getCodebase()!=null)
      setAudioClip (getSimulation().getCodebase().toString(),_audio);
    else setAudioClip (null,_audio);
  }

}