/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import org.opensourcephysics.ejs.control.value.Value;

/**
 * A configurable panel. It has no internal value, nor can trigger
 * any action.
 */
public class ControlPanel extends ControlContainer {
  protected JPanel panel;
  private java.awt.LayoutManager myLayout=null;
  private java.awt.Rectangle     myBorder=null;

// ------------------------------------------------
// Visual component
// ------------------------------------------------

  public ControlPanel (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) {
    if (_visual instanceof JPanel) panel = (JPanel) _visual;
    else panel = new JPanel();
    return panel;
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("layout");
      infoList.add ("border");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("layout"))         return "Layout|Object";
    if (_property.equals("border"))         return "Margins|Object";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : // layout
        if (_value.getObject() instanceof java.awt.LayoutManager) {
          java.awt.LayoutManager layout = (java.awt.LayoutManager) _value.getObject();
          if (layout!=myLayout) {
            getContainer().setLayout(myLayout=layout);
            panel.validate();
          }
        }
        break;
      case 1 : // border
        if (_value.getObject() instanceof java.awt.Rectangle) {
          java.awt.Rectangle rect = (java.awt.Rectangle) _value.getObject();
          if (rect!=myBorder) {
            panel.setBorder(new EmptyBorder(rect.x,rect.y,rect.width,rect.height));
            myBorder = rect;
          }
        }
        break;
      default: super.setValue(_index-2,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 :
        getContainer().setLayout(myLayout = new java.awt.BorderLayout());
        panel.validate();
        break;
      case 1 : panel.setBorder(null); myBorder = null; break;
      default: super.setDefaultValue(_index-2); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : case 1 :
        return null;
      default: return super.getValue(_index-2);
    }
  }

} // End of class