/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import javax.swing.JLabel;

import org.opensourcephysics.ejs.control.value.Value;

/**
 * A configurable Label. It has no internal value, nor can trigger
 * any action.
 */
public class ControlLabel extends ControlSwingElement {
  protected JLabel label;
  private String imageFile = null;

// ------------------------------------------------
// Visual component
// ------------------------------------------------

  public ControlLabel (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) {
    if (_visual instanceof JLabel) label = (JLabel) _visual;
    else label = new JLabel ();
    return label;
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("text");
      infoList.add ("image");
      infoList.add ("alignment");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("text"))      return "String NotTrimmed";
    if (_property.equals("image"))     return "File|String";
    if (_property.equals("alignment")) return "Alignment|int";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : label.setText(_value.getString()); break;  // text
      case 1 : // image
        if (_value.getString().equals(imageFile)) return; // no need to do it again
        label.setIcon (getIcon(imageFile = _value.getString()));
        break;
      case 2 : label.setHorizontalAlignment(_value.getInteger()); break; // alignment
      default: super.setValue(_index-3,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : label.setText(""); break;
      case 1 : label.setIcon(null); imageFile = null; break;
      case 2 : label.setHorizontalAlignment(javax.swing.SwingConstants.CENTER ); break;
      default: super.setDefaultValue(_index-3); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : case 1 : case 2 :
        return null;
      default: return super.getValue(_index-3);
    }
  }

} // End of class