/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import org.opensourcephysics.controls.ParsableTextArea;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlInputArea extends ControlSwingElement {
  protected ParsableTextArea inputarea;
  private javax.swing.JScrollPane pane;
  private TitledBorder titledBorder;
  private EtchedBorder etchedBorder;

// ------------------------------------------------
// Visual component
// ------------------------------------------------

  public ControlInputArea (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) {
    if (_visual instanceof ParsableTextArea) inputarea = (ParsableTextArea) _visual;
    else {
      inputarea = new ParsableTextArea ();
      inputarea.setEditable(true);
    }
    pane = new javax.swing.JScrollPane(inputarea);
    etchedBorder = new EtchedBorder(EtchedBorder.LOWERED);
    titledBorder = new TitledBorder (etchedBorder,"");
    titledBorder.setTitleJustification (TitledBorder.CENTER);
    pane.setBorder (etchedBorder);
    return inputarea;
  }

  public java.awt.Component getComponent () { return pane; }

  public void reset () { inputarea.setText(""); }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("title");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("title")) return "String";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 :
        if (titledBorder.getTitle()==_value.getString()) return;
        titledBorder.setTitle (_value.getString());
        pane.setBorder (titledBorder);
        pane.repaint();
        break;
      default: super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 :
        pane.setBorder (etchedBorder);
        pane.repaint();
        break;
      default: super.setDefaultValue(_index-1); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 :
        return null;
      default: return super.getValue(_index-1);
    }
  }



} // End of class
