/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import javax.swing.JFrame;

import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * A configurable Frame. It has no internal value, nor can trigger
 * any action.
 */
public class ControlFrame extends ControlWindow {
  static private final int NAME = ControlWindow.NAME + 4;

  protected JFrame frame;

// ------------------------------------------------
// Visual component
// ------------------------------------------------
  public ControlFrame (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) {
    startingup = true;
    if (_visual instanceof JFrame) frame = (JFrame) _visual;
    else {
      frame = new JFrame ();
      frame.getContentPane().setLayout (new java.awt.BorderLayout());
    }
    frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
    internalValue = new BooleanValue (true);
    setProperty ("visible","true");
    frame.addWindowListener (new java.awt.event.WindowAdapter() {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        internalValue.value = false;
        variableChanged (ControlWindow.VISIBLE+4,internalValue);
        if (frame.getDefaultCloseOperation()==JFrame.EXIT_ON_CLOSE) {
//          System.out.println (frame.getName()+" is closing");
          invokeActions();
        }
      }
    });
    return frame.getContentPane();
  }

  public java.awt.Component getComponent () { return frame; }

  public java.awt.Container getContainer () { return frame.getContentPane(); }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("title");
      infoList.add ("resizable");
      infoList.add ("exit");
      infoList.add ("onExit");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("title"))          return "String";
    if (_property.equals("resizable"))      return "boolean BASIC";
    if (_property.equals("exit"))           return "boolean CONSTANT HIDDEN";
    if (_property.equals("onExit"))         return "Action CONSTANT HIDDEN";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : // title
        String ejsWindow = getProperty("_ejs_window_");
        if (ejsWindow!=null) frame.setTitle(_value.getString()+" "+ejsWindow);
        else frame.setTitle(_value.getString());
        break;
      case 1 : frame.setResizable(_value.getBoolean()); break;
      case 2 : // exit
        if (getProperty("_ejs_")==null) {
          if (_value.getBoolean()) frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
          else frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
        }
        break;
      case 3 : // action
        removeAction (ControlElement.ACTION,getProperty("onExit"));
        addAction(ControlElement.ACTION,_value.getString());
        break;
      case NAME : // Overrides ControlElement's 'name'
        super.setValue(ControlWindow.NAME,_value);
        if (getGroup()!=null && getGroup().getOwnerFrame()==getComponent()) {
          String replacement = getGroup().getReplaceOwnerName();
          if (replacement!=null && replacement.equals(_value.getString()))
            getGroup().setOwnerFrame(getGroup().getReplaceOwnerFrame());
          else getGroup().setOwnerFrame(frame);
        }
        break;
      default: super.setValue(_index-4,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : // title
        String ejsWindow = getProperty("_ejs_window_");
        if (ejsWindow!=null) frame.setTitle(ejsWindow);
        else frame.setTitle("");
        break;
      case 1 : frame.setResizable(true); break;
      case 2 : // exit
        if (getProperty("_ejs_")==null) {
          frame.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
        }
        break;
      case 3 : removeAction (ControlElement.ACTION,getProperty("onExit"));       break;
      case NAME : // Overrides ControlElement's 'name'
        super.setDefaultValue (ControlWindow.NAME);
        if (getGroup()!=null && getGroup().getOwnerFrame()==getComponent()) {
          getGroup().setOwnerFrame(frame);
        }
      default: super.setDefaultValue(_index-4); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 :
      case 1 :
      case 2 :
      case 3 :
        return null;
      default: return super.getValue(_index-4);
    }
  }


} // End of 2class