/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) Dec 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import java.util.Enumeration;
import java.util.Vector;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.ejs.control.NeedsUpdate;

/**
 * A container to hold Drawables.
 * The base class for ControlDrawingParent, ControlDrawingPanel3D and ControlPlottingPanel
 * Its visual MUST be a (subclass of) DrawingPanel
 * It is prepared for interaction, if the visual is interactive
 */
public abstract class ControlDrawablesParent extends ControlSwingElement implements NeedsUpdate {

  // List of children that need to do something before repainting the panel
  private Vector preupdateList = new Vector();

  public ControlDrawablesParent (Object _visual) { super (_visual); }

  public void update () { // Ensure it will be updated
    // First prepare children that need to do something
    for (Enumeration e=preupdateList.elements(); e.hasMoreElements(); )
      ((NeedsPreUpdate) e.nextElement()).preupdate();
    // Now render
    ((DrawingPanel) getVisual()).render();
//      ((DrawingPanel) getVisual()).repaint(); // OSP Update July 2003
  }

  public void addToPreupdateList (NeedsPreUpdate _child) {
//    System.out.println ("Adding "+_child);
    preupdateList.add(_child);
  }

  public void removeFromPreupdateList (NeedsPreUpdate _child) {
    preupdateList.remove(_child);
  }

// ------------------------------------------------
// This prepares it for interaction within Ejs
// ------------------------------------------------

  public ControlDrawable getSelectedDrawable() { return null; }

} // End of class
