/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) Dec 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * Abstract superclass for Drawables (children of ControlDrawableParent)
 */
public abstract class ControlDrawable extends ControlElement {
  public static final int NAME    = 0; // The name of the element
  public static final int PARENT  = 1; // The parent of the element

  protected ControlDrawablesParent myParent;
  private   Drawable myDrawable = null; // change with care

  /**
   * Constructor and utilities
   */
  public ControlDrawable(Object _drawable) {
    super (_drawable);
    myDrawable = createDrawable(_drawable);
    super.myObject = myDrawable;
  }

  protected abstract Drawable createDrawable (Object drawable);

  final public Drawable getDrawable () { return myDrawable; }
  // use with care. Some may need it (like ByteRaster f.i.)
  final public void setDrawable (Drawable _dr) { myDrawable = _dr; }

  // This one is not final because of ControlZSurfacePlot, f. i.
  public void setParent (ControlDrawablesParent _dp) {
     // System.out.println ("Setting parent of "+this+" to "+_dp);
    if (myParent!=null) {
      ( (DrawingPanel) myParent.getVisual()).removeDrawable(myDrawable);
      if (this instanceof NeedsPreUpdate) myParent.removeFromPreupdateList((NeedsPreUpdate)this);
    }
    if (_dp!=null) {
      ((DrawingPanel) _dp.getVisual ()).addDrawable(myDrawable);
      ((DrawingPanel) _dp.getVisual ()).render();
      if (this instanceof NeedsPreUpdate) _dp.addToPreupdateList((NeedsPreUpdate)this);
      myParent = _dp;
    }
  }
  final public ControlDrawablesParent getParent () { return myParent; }

  public void destroy () {
    super.destroy();
    if (myParent!=null) ((DrawingPanel) myParent.getVisual ()).render();
  }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() { // This eliminates any previous property
    if (infoList==null) {
      infoList = new java.util.ArrayList();
      infoList.add ("name");
      infoList.add ("parent");
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("name"))    return "String         CONSTANT HIDDEN";
    if (_property.equals("parent"))  return "ControlElement CONSTANT HIDDEN";
    return null;
  }

// ------------------------------------------------
// Variables
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case NAME : super.setValue (ControlElement.NAME,_value); break;
      case PARENT :
        {
          ControlElement parent = myGroup.getElement(getProperty("parent"));
          if (parent!=null) setParent (null);
          parent = myGroup.getElement(_value.toString());
          if (parent==null) System.err.println (getClass().getName()+" : Error! Parent <"+_value+"> not found for "+toString());
          else {
            if (parent instanceof ControlDrawablesParent) setParent ((ControlDrawablesParent) parent);
            else System.err.println (getClass().getName()+" : Error! Parent <"+_value+"> is not a ControlDrawablesParent");
          }
        }
        break;
      default : // Do nothing. No inherited properties
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case NAME : super.setDefaultValue (ControlElement.NAME); break;
      case PARENT :
        {
          ControlElement parent = myGroup.getElement(getProperty("parent"));
          if (parent!=null) setParent (null);
        }
        break;
      default : break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      default: return null;
    }
  }

} // End of class

