/*
 * The control.swing package contains subclasses of control.ControlElement
 * that create visuals using Java's Swing library
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.swing;

import javax.swing.JDialog;

import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * A configurable Dialog.
 */
public class ControlDialog extends ControlWindow {
  protected JDialog dialog;


// ------------------------------------------------
// Visual component
// ------------------------------------------------
  public ControlDialog (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) { return createDialog(_visual,null); }

  // This is a very special case
  public void replaceVisual (java.awt.Frame _owner) { myVisual = createDialog (null,_owner); }

  // This is a very special case
  private java.awt.Component createDialog (Object _visual, java.awt.Frame _owner) {
    startingup = true;
    if (_visual instanceof JDialog) {
      dialog = (JDialog) _visual;
    }
    else {
      if (_owner!=null) dialog = new JDialog (_owner);
      else dialog = new JDialog ();
      dialog.getContentPane().setLayout (new java.awt.BorderLayout());
    }
    internalValue = new BooleanValue (true);
    setProperty ("visible","true");
    dialog.addWindowListener (new java.awt.event.WindowAdapter() {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        internalValue.value = false;
        variableChanged (ControlWindow.VISIBLE+2,internalValue);
      }
    });
    return dialog.getContentPane();
  }

  public java.awt.Component getComponent () { return dialog; }

  public java.awt.Container getContainer () { return dialog.getContentPane(); }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("title");
      infoList.add ("resizable");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("title"))     return "String";
    if (_property.equals("resizable")) return "boolean BASIC";
    return super.getPropertyInfo(_property);
  }

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : // title
        String ejsWindow = getProperty("_ejs_window_");
        if (ejsWindow!=null) dialog.setTitle(_value.getString()+" "+ejsWindow);
        else dialog.setTitle(_value.getString());
        break;
      case 1 : dialog.setResizable(_value.getBoolean()); break;
      default: super.setValue(_index-2,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : // title
        String ejsWindow = getProperty("_ejs_window_");
        if (ejsWindow!=null) dialog.setTitle(ejsWindow);
        else dialog.setTitle("");
        break;
      case 1 : dialog.setResizable(true); break;
      default: super.setDefaultValue(_index-2); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : case 1 :
        return null;
      default: return super.getValue(_index-2);
    }
  }

} // End of class