/*
 * The control.drawables package contains subclasses of
 * control.ControlElement that create Drawables for inclusion in
 * a DrawingPanel
 * Copyright (c) July 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.drawables;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display2d.ByteRaster;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlByteRaster extends ControlDrawable2D {
  protected ByteRaster raster;
  private double minX, maxX,minY, maxY;
  private int nx, ny;

  public ControlByteRaster (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof ByteRaster) raster = (ByteRaster) _drawable;
    else raster = new ByteRaster(300,300);
    nx = raster.getNx();
    ny = raster.getNy();
    raster.setMinMax(minX=-1.0,maxX=1.0,minY=-1.0,maxY=1.0);
    raster.randomize();
    return raster;
  }

// ------------------------------------------------
// Visual component
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("minimumX");
      infoList.add ("maximumX");
      infoList.add ("minimumY");
      infoList.add ("maximumY");
      infoList.add ("data");
      infoList.add ("visible");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("minimumX"))      return "int|double BASIC";
    if (_property.equals("maximumX"))      return "int|double BASIC";
    if (_property.equals("minimumY"))      return "int|double BASIC";
    if (_property.equals("maximumY"))      return "int|double BASIC";
    if (_property.equals("data"))          return "int[][]";
    if (_property.equals("visible"))       return "boolean";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : if (_value.getDouble()!=minX) raster.setXMin(minX=_value.getDouble()); break;
      case 1 : if (_value.getDouble()!=maxX) raster.setXMax(maxX=_value.getDouble()); break;
      case 2 : if (_value.getDouble()!=minY) raster.setYMin(minY=_value.getDouble()); break;
      case 3 : if (_value.getDouble()!=maxY) raster.setYMax(maxY=_value.getDouble()); break;
      case 4 :
        if (_value.getObject() instanceof int[][]) {
          int [][] data = (int[][])_value.getObject();
          if (data.length!=nx || data[0].length!=ny) raster.resizeRaster(nx=data.length,ny=data[0].length);
          raster.setBlock(0,0,data);
        }
        break;
      case 5 : raster.setVisible(_value.getBoolean()); break;
      default: super.setValue(_index-6,_value);
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : raster.setXMin(minX=-1.0); break;
      case 1 : raster.setXMax(maxX=1.0); break;
      case 2 : raster.setYMin(minY=-1.0); break;
      case 3 : raster.setYMax(maxY=1.0); break;
      case 4 : raster.randomize(); break;
      case 5 : raster.setVisible(true); break;
      default: super.setDefaultValue(_index-6); break;
    }
  }

  public Value getValue (int _index) {
    switch(_index) {
      case 0 : case 1 : case 2 :
      case 3 : case 4 : case 5 :
        return null; // The element does not modify these
      default: return super.getValue(_index-6);
    }
  }

}