/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.VectorField3D;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlVectorField3D extends ControlDrawable3D {
  protected VectorField3D vectorfield3d;
  private boolean auto;
  private double minC, maxC, zoom;
  private int levels;
  private Color mincolor, maxcolor;

  public ControlVectorField3D (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof VectorField3D) vectorfield3d = (VectorField3D) _drawable;
    else vectorfield3d = new VectorField3D();
    minC = 0.0;
    maxC = 1.0;
    zoom = 1.0;
    levels = 0;
    vectorfield3d.setAutoscaleMagnitude(auto=true);
    vectorfield3d.setInvisibleLevel(-1);
    return vectorfield3d;
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("data");
      infoList.add ("autoscale");
      infoList.add ("minimum");
      infoList.add ("maximum");
      infoList.add ("levels");
      infoList.add ("mincolor");
      infoList.add ("maxcolor");
      infoList.add ("zoom");
      infoList.add ("visible");
      infoList.add ("invisibleLevel");

/*
      infoList.add ("x");
      infoList.add ("y");
      infoList.add ("z");
      infoList.add ("sizex");
      infoList.add ("sizey");
      infoList.add ("sizez");
      infoList.add ("stroke");
*/
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("data"))          return "double[][][][]|double[][][]";
    if (_property.equals("autoscale"))     return "boolean BASIC";
    if (_property.equals("minimum"))       return "int|double";
    if (_property.equals("maximum"))       return "int|double";
    if (_property.equals("levels"))        return "int";
    if (_property.equals("mincolor"))      return "Color|Object BASIC";
    if (_property.equals("maxcolor"))      return "Color|Object BASIC";
    if (_property.equals("zoom"))          return "int|double BASIC";
    if (_property.equals("visible"))       return "boolean BASIC";
    if (_property.equals("invisibleLevel"))return "int";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 :
        if      (_value.getObject() instanceof double[][][][]) vectorfield3d.setDataArray((double[][][][])_value.getObject());
        else if (_value.getObject() instanceof double[][][])   vectorfield3d.setDataArray((double[][][])_value.getObject());
        break;
      case 1 : if (auto!=_value.getBoolean()) vectorfield3d.setAutoscaleMagnitude(auto=_value.getBoolean()); break;
      case 2 : if (_value.getDouble()!=minC)  vectorfield3d.setColorExtrema(minC=_value.getDouble(),maxC);   break;
      case 3 : if (_value.getDouble()!=maxC)  vectorfield3d.setColorExtrema(minC,maxC=_value.getDouble());   break;
      case 4 : if (_value.getInteger()!=levels) vectorfield3d.setNumberOfLevels(levels=_value.getInteger()); break;
      case 5 : if (mincolor!=(Color) _value.getObject()) vectorfield3d.setMinColor(mincolor=(Color)_value.getObject()); break;
      case 6 : if (maxcolor!=(Color) _value.getObject()) vectorfield3d.setMaxColor(maxcolor=(Color)_value.getObject()); break;
      case 7 : if (_value.getDouble()!=zoom) vectorfield3d.setZoom (zoom=_value.getDouble()); break;
      case 8 : vectorfield3d.setVisible(_value.getBoolean()); break;
      case 9 : vectorfield3d.setInvisibleLevel(_value.getInteger()); break;
      default: super.setValue(_index-10,_value);
    }
  }


  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : vectorfield3d.setDataArray((double[][][])null); break;
      case 1 : vectorfield3d.setAutoscaleMagnitude(auto=true); break;
      case 2 : vectorfield3d.setColorExtrema(minC=0.0,maxC);   break;
      case 3 : vectorfield3d.setColorExtrema(minC,maxC=1.0);   break;
      case 4 : vectorfield3d.setNumberOfLevels(levels=16);     break;
      case 5 : vectorfield3d.setMinColor(mincolor=Color.blue); break;
      case 6 : vectorfield3d.setMaxColor(maxcolor=Color.red);  break;
      case 7 : vectorfield3d.setZoom (zoom=1.0);  break;
      case 8 : vectorfield3d.setVisible(true); break;
      case 9 : vectorfield3d.setInvisibleLevel(-1); break;
      default: super.setDefaultValue(_index-10); break;
    }
  }

  public Value getValue (int _index) {
    switch(_index) {
      case 0 : case 1 : case 2 : case 3 :
      case 4 : case 5 : case 6 : case 7 :
      case 8 : case 9 :
        return null;
      default: return super.getValue(_index-10);
    }
  }

}