/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive set of particles
 */
public class ControlTextSet extends ControlElementSet {

  public ControlTextSet (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof ElementSet) elementSet = (ElementSet) _drawable;
    else {
      elementSet = new ElementSet(1, InteractiveText.class);
      elementSet.setEnabled(InteractiveElement.TARGET_POSITION,true);  // Backwards compatibility
    }
/*
    allposValues     = new ObjectValue[3];
    allposValues[0]  = new ObjectValue(theXs = elementSet.getXs());
    allposValues[1]  = new ObjectValue(theYs = elementSet.getYs());
    allposValues[2]  = new ObjectValue(theZs = elementSet.getZs());
    allsizesValue    = new ObjectValue[3];
    allsizesValue[0] = new ObjectValue(theSizeXs = elementSet.getSizeXs());
    allsizesValue[1] = new ObjectValue(theSizeYs = elementSet.getSizeYs());
    allsizesValue[2] = new ObjectValue(theSizeZs = elementSet.getSizeZs());
    elementSet.addListener(this);
    defaultFont = font = elementSet.elementAt(0).getStyle().getFont();
*/
    return elementSet;
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("text"))             return "String|String[]";
    if (_property.equals("enabledSecondary")) return "boolean HIDDEN";
    if (_property.equals("resolution"))       return "Resolution BASIC HIDDEN";
    if (_property.equals("angle"))            return "int|double BASIC HIDDEN";

    // These have no efect (for the moment)
    if (_property.equals("sizex"))       return "int|double HIDDEN";
    if (_property.equals("sizey"))       return "int|double HIDDEN";
    if (_property.equals("sizez"))       return "int|double HIDDEN";
    if (_property.equals("scalex"))   return "int|double BASIC HIDDEN";
    if (_property.equals("scaley"))   return "int|double BASIC HIDDEN";
    if (_property.equals("scalez"))   return "int|double BASIC HIDDEN";

    if (_property.equals("style"))          return "MarkerShape|int BASIC HIDDEN";
    if (_property.equals("stroke"))         return "int|double|Object BASIC HIDDEN";
    if (_property.equals("secondaryColor")) return "Color|Object BASIC HIDDEN";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Variable properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case TEXT :
        if (_value instanceof ObjectValue) {
          String[] val = (String[])_value.getObject();
          for (int i=0, n=Math.min(elementSet.getNumberOfElements(),val.length); i<n; i++) elementSet.elementAt(i).getStyle().setDisplayObject(val[i]);
        }
        else {
          String val = _value.toString();
          for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) elementSet.elementAt(i).getStyle().setDisplayObject(val);
        }
        break;
      default: super.setValue(_index,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case  TEXT : for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) elementSet.elementAt(i).getStyle().setDisplayObject(""); break;
      default: super.setDefaultValue(_index); break;
    }
  }

} // End of class