/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveText;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive particle
 */
public class ControlText extends ControlInteractiveElement {
  protected InteractiveText text;

  public ControlText (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof InteractiveText) text = (InteractiveText) _drawable;
    else text = new InteractiveText();
    text.setEnabled(InteractiveElement.TARGET_POSITION,true);  // Backwards compatibility
    return text;
  }

  static private final int[] posSpot = {1,2,3};
  static private final int[] sizeSpot = {4,5,6};

  int[] getPosSpot ()  { return posSpot; }
  int[] getSizeSpot ()  { return sizeSpot; }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("text");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("text"))             return "String";
    if (_property.equals("enabledSecondary")) return "boolean HIDDEN";
    if (_property.equals("resolution"))       return "Resolution BASIC HIDDEN";
    if (_property.equals("angle"))            return "int|double BASIC HIDDEN";

    // These have no efect (for the moment)
    if (_property.equals("sizex"))       return "int|double HIDDEN";
    if (_property.equals("sizey"))       return "int|double HIDDEN";
    if (_property.equals("sizez"))       return "int|double HIDDEN";
    if (_property.equals("scalex"))   return "int|double BASIC HIDDEN";
    if (_property.equals("scaley"))   return "int|double BASIC HIDDEN";
    if (_property.equals("scalez"))   return "int|double BASIC HIDDEN";

    if (_property.equals("style"))          return "MarkerShape|int BASIC HIDDEN";
    if (_property.equals("stroke"))         return "int|double|Object BASIC HIDDEN";
    if (_property.equals("secondaryColor")) return "Color|Object BASIC HIDDEN";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case  0 : text.getStyle().setDisplayObject(_value.getString()); break;
      default: super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case  0 : text.getStyle().setDisplayObject(""); break;
      default: super.setDefaultValue(_index-1); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : return null;
      default: return super.getValue(_index-1);
    }
  }

} // End of class