/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive set of particles
 */
public class ControlSpringSet extends ControlElementSet {

  public ControlSpringSet (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof ElementSet) elementSet = (ElementSet) _drawable;
    else {
      elementSet = new ElementSet(1, InteractiveSpring.class);
      elementSet.setEnabled(InteractiveElement.TARGET_SIZE, true); // Backwards compatibility
    }
/*
    allposValues     = new ObjectValue[3];
    allposValues[0]  = new ObjectValue(theXs = elementSet.getXs());
    allposValues[1]  = new ObjectValue(theYs = elementSet.getYs());
    allposValues[2]  = new ObjectValue(theZs = elementSet.getZs());
    allsizesValue    = new ObjectValue[3];
    allsizesValue[0] = new ObjectValue(theSizeXs = elementSet.getSizeXs());
    allsizesValue[1] = new ObjectValue(theSizeYs = elementSet.getSizeYs());
    allsizesValue[2] = new ObjectValue(theSizeZs = elementSet.getSizeZs());
    elementSet.addListener(this);
    defaultFont = font = elementSet.elementAt(0).getStyle().getFont();
*/
    return elementSet;
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("radius"))          return "int|double|double[]";

    if (_property.equals("style"))           return "ArrowStyle|int BASIC HIDDEN";
    if (_property.equals("elementposition")) return "ElementPosition|int BASIC HIDDEN";
    if (_property.equals("angle"))           return "int|double BASIC HIDDEN";
    if (_property.equals("secondaryColor"))  return "Color|Object BASIC HIDDEN";
    if (_property.equals("font"))            return "Font|Object  BASIC HIDDEN";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case RADIUS :
        if (_value.getObject() instanceof double[]) {
            double[] val = (double[]) _value.getObject();
            for (int i=0, n=Math.min(elementSet.getNumberOfElements(),val.length); i<n; i++) ((InteractiveSpring)elementSet.elementAt(i)).setRadius(val[i]);
          }
          else {
            double val = _value.getDouble();
            for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) ((InteractiveSpring)elementSet.elementAt(i)).setRadius(val);
          }
        break;
      case ENABLED :
        if (_value.getObject() instanceof boolean[]) elementSet.setEnableds(InteractiveElement.TARGET_SIZE,(boolean[]) _value.getObject());
        else elementSet.setEnabled(InteractiveElement.TARGET_SIZE,_value.getBoolean());
        break;
      case ENABLED_SECONDARY :
        if (_value.getObject() instanceof boolean[]) elementSet.setEnableds(InteractiveElement.TARGET_POSITION,(boolean[]) _value.getObject());
        else elementSet.setEnabled(InteractiveElement.TARGET_POSITION,_value.getBoolean());
        break;

      default: super.setValue(_index,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case RADIUS : for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) ((InteractiveSpring)elementSet.elementAt(i)).setRadius(0.1);
      case ENABLED : elementSet.setEnabled(InteractiveElement.TARGET_SIZE,true); break;
      case ENABLED_SECONDARY : elementSet.setEnabled(InteractiveElement.TARGET_POSITION,false); break;
      default: super.setDefaultValue(_index); break;
    }
  }

} // End of class