/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */


package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSpring extends ControlInteractiveElement {
  static private final int MY_ENABLED = ENABLED+1;
  static private final int MY_ENABLED_SECONDARY = ENABLED_SECONDARY+1;

  public ControlSpring (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof InteractiveSpring) return (InteractiveSpring) _drawable;
    else {
      InteractiveSpring spring = new InteractiveSpring();
      spring.setEnabled(InteractiveElement.TARGET_SIZE,true); // Backwards compatibility
      return  spring;
    }
  }

  static private final int[] posSpot = {1,2,3};
  static private final int[] sizeSpot = {4,5,6};

  int[] getPosSpot ()  { return posSpot; }
  int[] getSizeSpot ()  { return sizeSpot; }


// ------------------------------------------------
// Properties
// ------------------------------------------------

  static java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("radius");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("radius"))          return "int|double";

    if (_property.equals("style"))           return "ArrowStyle|int BASIC HIDDEN";
    if (_property.equals("elementposition")) return "ElementPosition|int BASIC HIDDEN";
    if (_property.equals("angle"))           return "int|double BASIC HIDDEN";
    if (_property.equals("secondaryColor"))  return "Color|Object BASIC HIDDEN";
    if (_property.equals("font"))            return "Font|Object  BASIC HIDDEN";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : ((InteractiveSpring) myElement).setRadius(_value.getDouble());
      case MY_ENABLED           : myElement.setEnabled(InteractiveElement.TARGET_SIZE,_value.getBoolean()); break;
      case MY_ENABLED_SECONDARY : myElement.setEnabled(InteractiveElement.TARGET_POSITION,_value.getBoolean()); break;
      default: super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : ((InteractiveSpring) myElement).setRadius(0.1);
      case MY_ENABLED           : myElement.setEnabled(InteractiveElement.TARGET_SIZE,true); break;
      case MY_ENABLED_SECONDARY : myElement.setEnabled(InteractiveElement.TARGET_POSITION,false); break;
      default: super.setDefaultValue(_index-1); break;
    }
  }

} // End of class