/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveSphere;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSphere extends ControlCylinder {

  public ControlSphere (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    InteractiveSphere sphere;
    if (_drawable instanceof InteractiveSphere) sphere = (InteractiveSphere) _drawable;
    else sphere = new InteractiveSphere();
    sphere.setOrigin(0.5,0.5,0.5,true);
    return sphere;
  }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("minanglev"))  return "int|double BASIC";
    if (_property.equals("maxanglev"))  return "int|double BASIC";
    return super.getPropertyInfo(_property);
  }

  public ControlElement setProperty(String _property, String _value) {
    _property = _property.trim();
    if (_property.equals("dx")) return super.setProperty ("sizex","2*"+_value);
    if (_property.equals("dy")) return super.setProperty ("sizey","2*"+_value);
    if (_property.equals("dz")) return super.setProperty ("sizez","2*"+_value);
    if (_property.equals("linecolor")) return super.setProperty ("secondaryColor",_value);
    return super.setProperty(_property,_value);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 4 : ((InteractiveSphere) myElement).setMinAngleV(_value.getInteger());      break;
      case 5 : ((InteractiveSphere) myElement).setMaxAngleV(_value.getInteger());      break;
      default : super.setValue(_index,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 4 : ((InteractiveSphere) myElement).setMinAngleV(0);      break;
      case 5 : ((InteractiveSphere) myElement).setMaxAngleV(360);      break;
      default: super.setDefaultValue(_index); break;
    }
  }

} // End of interface