/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractivePoints;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive particle
 */
public class ControlPoints extends ControlInteractiveElement {

  public ControlPoints (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof InteractivePoints) return (InteractivePoints) _drawable;
    else return new InteractivePoints();
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("data");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("data"))             return "double[][]  BASIC";

    if (_property.equals("enabled"))          return "HIDDEN";
    if (_property.equals("enabledSecondary")) return "HIDDEN";

    if (_property.equals("style"))          return "HIDDEN";
    if (_property.equals("elementposition"))return "HIDDEN";
    if (_property.equals("angle"))          return "HIDDEN";
    if (_property.equals("resolution"))     return "HIDDEN";

    if (_property.equals("secondaryColor")) return "HIDDEN";
    if (_property.equals("font"))           return "HIDDEN";

    if (_property.equals("action"))      return "HIDDEN";
    if (_property.equals("pressaction")) return "HIDDEN";
    if (_property.equals("dragaction"))  return "HIDDEN";

    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get values
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 : if (_value.getObject() instanceof double[][]) ((InteractivePoints) myElement).setData((double[][])_value.getObject()); break;
      default : super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : ((InteractivePoints) myElement).setData(null); break;
      default : super.setDefaultValue(_index-1); break;
    }
  }

} // End of class