/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractivePlane;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlPlane extends ControlInteractiveTile {
  static final int PROPERTIES_PLANE=PROPERTIES_ADDED+2;

  public ControlPlane (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    InteractivePlane plane;
    if (_drawable instanceof InteractivePlane) plane = (InteractivePlane) _drawable;
    else plane = new InteractivePlane();
    plane.setOrigin(0,0,0,true);
    return plane;
  }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  static java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("direction1");
      infoList.add ("direction2");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("direction1"))       return "Vector3D|double[]";
    if (_property.equals("direction2"))       return "Vector3D|double[]";

    if (_property.equals("sizez")) return "HIDDEN";
    if (_property.equals("enabledSecondary")) return "HIDDEN";
    return super.getPropertyInfo(_property);
  }

  public Value parseConstant (String _propertyType, String _value) {
    if (_value==null) return null;
    if (_propertyType.indexOf("Vector3D")>=0) {
      try {
        java.util.StringTokenizer t = new java.util.StringTokenizer(_value,",");
        double u1 = Double.parseDouble(t.nextToken());
        double u2 = Double.parseDouble(t.nextToken());
        double u3 = Double.parseDouble(t.nextToken());
        return new ObjectValue(new double[]{u1,u2,u3});
      } catch (Exception exc) {
        System.out.println ("Incorrect 3D vector");
        exc.printStackTrace();
      }
    }
    return super.parseConstant (_propertyType,_value);
  }


// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case 0 :
        if (_value.getObject() instanceof double[]) {
          double[] val = (double[]) _value.getObject();
          ( (InteractivePlane) myElement).setVectorU(val[0], val[1], val[2]);
        }
        break;
      case 1 :
        if (_value.getObject() instanceof double[]) {
          double[] val = (double[]) _value.getObject();
          ( (InteractivePlane) myElement).setVectorV(val[0], val[1], val[2]);
        }
        break;
      default : super.setValue(_index-2,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 0 : ((InteractivePlane) myElement).setVectorU(1.0,0.0,0.0); break;
      case 1 : ((InteractivePlane) myElement).setVectorV(0.0,1.0,0.0); break;
      default: super.setDefaultValue(_index-2); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : case 1 : return null;
      default: return getValue (_index-2);
    }
  }


// -------------------------------------
// Respond to interaction
// -------------------------------------

  static private final int[] posSpot  = {0+PROPERTIES_PLANE,1+PROPERTIES_PLANE,2+PROPERTIES_PLANE};
  static private final int[] sizeSpot = {3+PROPERTIES_PLANE,4+PROPERTIES_PLANE,5+PROPERTIES_PLANE};

  int[] getPosSpot ()  { return posSpot; }
  int[] getSizeSpot ()  { return sizeSpot; }

} // End of interface