/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import java.awt.Paint;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive set of particles
 */
public class ControlParticleSet extends ControlElementSet {

  public ControlParticleSet (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof ElementSet) elementSet = (ElementSet) _drawable;
    else {
      elementSet = new ElementSet(1, InteractiveParticle.class);
      elementSet.setEnabled(InteractiveElement.TARGET_POSITION,true);  // Backwards compatibility
    }

/*
    allposValues     = new ObjectValue[3];
    allposValues[0]  = new ObjectValue(theXs = elementSet.getXs());
    allposValues[1]  = new ObjectValue(theYs = elementSet.getYs());
    allposValues[2]  = new ObjectValue(theZs = elementSet.getZs());
    allsizesValue    = new ObjectValue[3];
    allsizesValue[0] = new ObjectValue(theSizeXs = elementSet.getSizeXs());
    allsizesValue[1] = new ObjectValue(theSizeYs = elementSet.getSizeYs());
    allsizesValue[2] = new ObjectValue(theSizeZs = elementSet.getSizeZs());
    elementSet.addListener(this);
    defaultFont = font = elementSet.elementAt(0).getStyle().getFont();
*/
    return elementSet;
  }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("enabledSecondary")) return "boolean HIDDEN";
    if (_property.equals("resolution"))       return "Resolution BASIC HIDDEN";
    if (_property.equals("font"))             return "Font|Object  BASIC HIDDEN";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Variable properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case STYLE :
        if (_value.getObject() instanceof int[]) {
            int[] val = (int[]) _value.getObject();
            for (int i=0, n=Math.min(elementSet.getNumberOfElements(),val.length); i<n; i++) ((InteractiveParticle)elementSet.elementAt(i)).setShapeType(val[i]);
          }
          else {
            int val = _value.getInteger();
            for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) ((InteractiveParticle)elementSet.elementAt(i)).setShapeType(val);
          }
        break;

      case PRIMARY_COLOR :
        if (_value.getObject() instanceof Object[]) {
          Object[] val = (Object[]) _value.getObject();
          for (int i=0, n=Math.min(elementSet.getNumberOfElements(),val.length); i<n; i++) elementSet.elementAt(i).getStyle().setFillPattern((Paint)val[i]);
        }
        else if (_value.getObject() instanceof Color) {
          Paint val = (Paint) _value.getObject();
          if (val==NULL_COLOR) val = null;
          for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) elementSet.elementAt(i).getStyle().setFillPattern(val);
        }
        break;

      case SECONDARY_COLOR :
        if (_value.getObject() instanceof Object[]) {
          Object[] val = (Object[]) _value.getObject();
          for (int i=0, n=Math.min(elementSet.getNumberOfElements(),val.length); i<n; i++) elementSet.elementAt(i).getStyle().setEdgeColor((Color)val[i]);
        }
        else if (_value.getObject() instanceof Color) {
          Color val = (Color) _value.getObject();
          for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) elementSet.elementAt(i).getStyle().setEdgeColor(val);
        }
        break;

      default: super.setValue(_index,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case STYLE :
        for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) ((InteractiveParticle)elementSet.elementAt(i)).setShapeType(InteractiveParticle.ELLIPSE);
        break;
      case PRIMARY_COLOR   : for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) elementSet.elementAt(i).getStyle().setFillPattern(Color.blue); break;
      case SECONDARY_COLOR : for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) elementSet.elementAt(i).getStyle().setEdgeColor(Color.black); break;
      default : super.setDefaultValue (_index); break;
    }
  }

} // End of class