/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive particle
 */
public class ControlParticle extends ControlInteractiveElement {

  public ControlParticle (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof InteractiveParticle) return (InteractiveParticle) _drawable;
    else {
      InteractiveParticle particle = new InteractiveParticle();
      particle.setEnabled(InteractiveElement.TARGET_POSITION,true);  // Backwards compatibility
      return particle;
    }
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("enabledSecondary")) return "boolean HIDDEN";
    if (_property.equals("resolution"))       return "Resolution BASIC HIDDEN";
    if (_property.equals("font"))             return "Font|Object  BASIC HIDDEN";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get values
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case STYLE           : ((InteractiveParticle) myElement).setShapeType (_value.getInteger()); break;
      case PRIMARY_COLOR   :
      {
      java.awt.Paint fill = (java.awt.Paint) _value.getObject();
      if (fill==NULL_COLOR) fill = null;
      myElement.getStyle().setFillPattern(fill);
      }
      break;
      case SECONDARY_COLOR : myElement.getStyle().setEdgeColor((java.awt.Color) _value.getObject()); break;
      default : super.setValue(_index,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case STYLE         : ((InteractiveParticle) myElement).setShapeType (InteractiveParticle.ELLIPSE); break;
      case PRIMARY_COLOR : myElement.getStyle().setFillPattern(java.awt.Color.blue); break;
      case SECONDARY_COLOR : myElement.getStyle().setEdgeColor(java.awt.Color.black); break;
      default : super.setDefaultValue(_index); break;
    }
  }

} // End of class