/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Paint;

import org.opensourcephysics.displayejs.AbstractInteractiveTile;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlInteractiveTile extends ControlInteractiveElement {
  static final public int PROPERTIES_ADDED=7;

  protected double colorLevels[]=null;
  protected Paint colorFills[]=null;
  protected double colorOrigin[] = new double[]{0.0,0.0,0.0};
  protected double colorDirection[] = new double[]{1.0,0.0,0.0};

  public ControlInteractiveTile (Object _visual) { super (_visual); }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  static java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("displacementFactor");
      infoList.add ("colorOrigin");
      infoList.add ("colorDirection");
      infoList.add ("colorLevels");
      infoList.add ("colorFills");
      infoList.add ("belowWhenEqual");
      infoList.add ("interiorTransparency");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("displacementFactor")) return "int|double BASIC";
    if (_property.equals("colorOrigin"))        return "double[] BASIC";
    if (_property.equals("colorDirection"))     return "double[] BASIC";
    if (_property.equals("colorLevels"))        return "double[] BASIC";
    if (_property.equals("colorFills"))         return "Object[] BASIC";
    if (_property.equals("belowWhenEqual"))     return "boolean BASIC";
    if (_property.equals("interiorTransparency"))     return "int BASIC";

    if (_property.equals("style"))          return "MarkerShape|int BASIC HIDDEN";
    if (_property.equals("elementposition"))return "ElementPosition|int BASIC HIDDEN";
    if (_property.equals("angle"))          return "int|double BASIC HIDDEN";

    if (_property.equals("font"))           return "Font|Object BASIC HIDDEN";

    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case  0 : ((AbstractInteractiveTile) myElement).setDisplacementFactor(_value.getDouble()); break;
      case  1 :
        if (_value.getObject() instanceof double[]) {
            double val[] = (double[]) _value.getObject();
            if (val.length>2) {
              colorOrigin = val;
              ((AbstractInteractiveTile) myElement).setColorOriginAndDirection(colorOrigin[0],colorOrigin[1],colorOrigin[2],
                  colorDirection[0],colorDirection[1],colorDirection[2]);
            }
        }
        break;
      case  2 :
        if (_value.getObject() instanceof double[]) {
          double val[] = (double[]) _value.getObject();
          if (val.length>2) {
            colorDirection = val;
            ((AbstractInteractiveTile) myElement).setColorOriginAndDirection(colorOrigin[0],colorOrigin[1],colorOrigin[2],
                colorDirection[0],colorDirection[1],colorDirection[2]);
          }
        }
        break;
      case  3 :
        if (_value.getObject() instanceof double[]) {
          colorLevels = (double[]) _value.getObject();
          if (colorFills!=null && colorFills.length==(colorLevels.length+1)) {
            ((AbstractInteractiveTile) myElement).setColorRegions(colorLevels,colorFills);
          }
        }
        break;
      case  4 :
        if (_value.getObject() instanceof Object[]) {
          colorFills = (Paint[]) _value.getObject();
          if (colorLevels!=null && colorLevels.length==(colorFills.length-1)) {
            ((AbstractInteractiveTile) myElement).setColorRegions(colorLevels,colorFills);
          }
        }
        break;
      case  5 : ((AbstractInteractiveTile) myElement).setColorBelowWhenEqual(_value.getBoolean()); break;
      case  6 : quickInterior(_value.getInteger()); break;

      default: super.setValue(_index-7,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case  0 : ((AbstractInteractiveTile) myElement).setDisplacementFactor(1.0); break;
      case  1 :
        colorOrigin = new double[] {0.0,0.0,0.0};
        ((AbstractInteractiveTile) myElement).setColorOriginAndDirection(colorOrigin[0],colorOrigin[1],colorOrigin[2],
            colorDirection[0],colorDirection[1],colorDirection[2]);
        break;
      case  2 :
        colorDirection = new double[] {1.0,0.0,0.0};
        ((AbstractInteractiveTile) myElement).setColorOriginAndDirection(colorOrigin[0],colorOrigin[1],colorOrigin[2],
            colorDirection[0],colorDirection[1],colorDirection[2]);
        break;
      case  3 : ((AbstractInteractiveTile) myElement).setColorRegions(colorLevels=null,null); break;
      case  4 : ((AbstractInteractiveTile) myElement).setColorRegions(null,colorFills=null); break;
      case  5 : ((AbstractInteractiveTile) myElement).setColorBelowWhenEqual(true); break;
      case  6 : quickInterior(-1); break;

      default: super.setDefaultValue(_index-7); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : case 1 : case 2 : case 3 : case 4 : case 5 : case 6 : return null;
      default: return getValue (_index-7);
    }
  }

  protected void quickInterior (int _trans) {
    if (_trans<0 || _trans>255) ((AbstractInteractiveTile) myElement).setDrawQuickInterior(false,0);
    else ((AbstractInteractiveTile) myElement).setDrawQuickInterior(true,_trans);
  }

} // End of interface