/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Image;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveImage;
import org.opensourcephysics.displayejs.utils.Utils;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive set of particles
 */
public class ControlImageSet extends ControlElementSet {
  private String imageFile=null;

  public ControlImageSet (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof ElementSet) elementSet = (ElementSet) _drawable;
    else {
      elementSet = new ElementSet(1, InteractiveImage.class);
      elementSet.setEnabled(InteractiveElement.TARGET_POSITION,true);  // Backwards compatibility
    }
/*
    allposValues     = new ObjectValue[3];
    allposValues[0]  = new ObjectValue(theXs = elementSet.getXs());
    allposValues[1]  = new ObjectValue(theYs = elementSet.getYs());
    allposValues[2]  = new ObjectValue(theZs = elementSet.getZs());
    allsizesValue    = new ObjectValue[3];
    allsizesValue[0] = new ObjectValue(theSizeXs = elementSet.getSizeXs());
    allsizesValue[1] = new ObjectValue(theSizeYs = elementSet.getSizeYs());
    allsizesValue[2] = new ObjectValue(theSizeZs = elementSet.getSizeZs());
    elementSet.addListener(this);
    defaultFont = font = elementSet.elementAt(0).getStyle().getFont();
*/
    return elementSet;
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("image"))            return "File|String|String[]";
    if (_property.equals("enabledSecondary")) return "boolean HIDDEN";
    if (_property.equals("style"))            return "MarkerShape|int BASIC HIDDEN";
    if (_property.equals("resolution"))       return "Resolution BASIC HIDDEN";
    if (_property.equals("font"))             return "Font|Object  BASIC HIDDEN";
    if (_property.equals("style"))            return "MarkerShape|int BASIC HIDDEN";
    if (_property.equals("color"))            return "Color|Object BASIC HIDDEN";
    if (_property.equals("stroke"))           return "int|double|Object BASIC HIDDEN";
    if (_property.equals("secondaryColor"))   return "Color|Object BASIC HIDDEN";
    if (_property.equals("font"))             return "Font|Object  BASIC HIDDEN";

    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Variable properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case IMAGE :
        if (_value instanceof ObjectValue && _value.getObject() instanceof String[]) setImages((String[])_value.getObject());
        else setImage(_value.getString());
        break;
      default: super.setValue(_index,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case IMAGE : setImage(null); break;
      default : super.setDefaultValue (_index); return;
    }
  }

// -------------------------------------
// private methods
// -------------------------------------

  private void setImage (String _image) {
    if (imageFile!=null && imageFile.equals(_image)) return; // no need to do it again
    imageFile = _image;
    javax.swing.ImageIcon icon=null;
    if (getProperty("_ejs_codebase")!=null) icon = Utils.icon(getProperty("_ejs_codebase"), _image);
    else if (getSimulation()!=null && getSimulation().getCodebase()!=null) icon = Utils.icon(getSimulation().getCodebase().toString(), _image);
    else icon = Utils.icon( (String)null, _image);
    if (icon!=null) {
      Image image = icon.getImage();
      for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) elementSet.elementAt(i).getStyle().setDisplayObject(image);
    }
  }

  private void setImages (String[] _images) {
    String codebase = getProperty("_ejs_codebase");
    if (codebase!=null) {
      for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) {
        javax.swing.ImageIcon icon = Utils.icon(codebase,_images[i]);
        if (icon!=null) elementSet.elementAt(i).getStyle().setDisplayObject(icon.getImage());
      }
    }
    else if (getSimulation()!=null && getSimulation().getCodebase()!=null) {
      codebase = getSimulation().getCodebase().toString();
      for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) {
        javax.swing.ImageIcon icon = Utils.icon(codebase,_images[i]);
        if (icon!=null) elementSet.elementAt(i).getStyle().setDisplayObject(icon.getImage());
      }
    }
    else {
      for (int i=0, n=elementSet.getNumberOfElements(); i<n; i++) {
        javax.swing.ImageIcon icon = Utils.icon((String) null,_images[i]);
        if (icon!=null) elementSet.elementAt(i).getStyle().setDisplayObject(icon.getImage());
      }
    }
  }

} // End of class