/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveImage;
import org.opensourcephysics.displayejs.utils.Utils;
import org.opensourcephysics.ejs.control.value.Value;

/**
 * An interactive particle
 */
public class ControlImage extends ControlInteractiveElement {
  protected InteractiveImage image;
  private String imageFile = null;

  public ControlImage (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof InteractiveImage) image = (InteractiveImage) _drawable;
    else {
      image = new InteractiveImage();
      image.setEnabled(InteractiveElement.TARGET_POSITION,true);  // Backwards compatibility
    }
    return image;
  }

  static private final int[] posSpot = {1,2,3};
  static private final int[] sizeSpot = {4,5,6};

  int[] getPosSpot ()  { return posSpot; }
  int[] getSizeSpot ()  { return sizeSpot; }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  static private java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("image");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }
  public String getPropertyInfo(String _property) {
    if (_property.equals("enabledSecondary")) return "boolean HIDDEN";
    if (_property.equals("style"))            return "MarkerShape|int BASIC HIDDEN";
    if (_property.equals("resolution"))       return "Resolution BASIC HIDDEN";
    if (_property.equals("font"))             return "Font|Object  BASIC HIDDEN";
    if (_property.equals("style"))            return "MarkerShape|int BASIC HIDDEN";
    if (_property.equals("color"))            return "Color|Object BASIC HIDDEN";
    if (_property.equals("stroke"))           return "int|double|Object BASIC HIDDEN";
    if (_property.equals("secondaryColor"))   return "Color|Object BASIC HIDDEN";
    if (_property.equals("font"))             return "Font|Object  BASIC HIDDEN";

    if (_property.equals("image"))    return "File|String";
    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case  0 : setImage(_value.getString());   break;
      default: super.setValue(_index-1,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case  0 : setImage(null);   break;
      default: super.setDefaultValue(_index-1); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : return null;
      default: return super.getValue(_index-1);
    }
  }

// -------------------------------------
// private methods
// -------------------------------------

  private void setImage (String _image) {
    if (imageFile!=null && imageFile.equals(_image)) return; // no need to do it again
    imageFile = _image;
    javax.swing.ImageIcon icon=null;
    if (getProperty("_ejs_codebase")!=null) icon = Utils.icon(getProperty("_ejs_codebase"),_image);
    else if (getSimulation()!=null && getSimulation().getCodebase()!=null) icon = Utils.icon(getSimulation().getCodebase().toString(),_image);
    else {
//      System.out.println ("Codebase 3 = "+_image);
      icon = Utils.icon( (String)null, _image);
    }
//    else icon = Utils.icon((String) null,_image);
    if (icon!=null) image.getStyle().setDisplayObject(icon.getImage());
  }

} // End of class
