/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */


package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;

/**
 * A configurable 3D panel from the displayejs package
 */
public class ControlDrawingPanel extends ControlDrawingPanel3D {

// ------------------------------------------------
// Visual component
// ------------------------------------------------
  public ControlDrawingPanel (Object _visual) { super (_visual); }

  protected java.awt.Component createVisual (Object _visual) {
    if (_visual instanceof DrawingPanel3D) drawingPanel3D = (DrawingPanel3D) _visual;
    else {
      drawingPanel3D = new DrawingPanel3D(DrawingPanel3D.DISPLAY_PLANAR_XY);
      drawingPanel3D.setDecorationType(DrawingPanel3D.DECORATION_CUBE);
      drawingPanel3D.setCursorMode(DrawingPanel3D.CURSOR_CROSSHAIR);
    }
    // drawingPanel3D.removeOptionController();
    minX = drawingPanel3D.getXMin();
    maxX = drawingPanel3D.getXMax();
    minY = drawingPanel3D.getYMin();
    maxY = drawingPanel3D.getYMax();
    minZ = drawingPanel3D.getZMin();
    maxZ = drawingPanel3D.getZMax();
    angleValues = new DoubleValue[2];
    angleValues[0] = new DoubleValue(drawingPanel3D.getAlpha());
    angleValues[1] = new DoubleValue(drawingPanel3D.getBeta());
    zoomValue = new DoubleValue(drawingPanel3D.getZoom());
    panValues = new IntegerValue[2];
    panValues[0]  = new IntegerValue(drawingPanel3D.getPan().x);
    panValues[1]  = new IntegerValue(drawingPanel3D.getPan().y);
    drawingPanel3D.addListener (this);
    drawingPanel3D.render();
    return drawingPanel3D;
  }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("autoscaleZ"))     return "boolean HIDDEN";
    if (_property.equals("minimumZ"))       return "int|double HIDDEN";
    if (_property.equals("maximumZ"))       return "int|double HIDDEN";
    if (_property.equals("z"))              return "int|double HIDDEN";

    if (_property.equals("alpha"))          return "int|double BASIC HIDDEN";
    if (_property.equals("beta"))           return "int|double BASIC HIDDEN";

    if (_property.equals("displayMode"))    return "int|DisplayMode BASIC HIDDEN";
    if (_property.equals("hideLines"))      return "boolean BASIC HIDDEN";

    return super.getPropertyInfo(_property);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setDefaultValue (int _index) {
    switch (_index) {
      case 23 : drawingPanel3D.setCursorMode    (DrawingPanel3D.CURSOR_NONE); break;
      default: super.setDefaultValue(_index); break;
    }
  }

} // End of class