/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveCone;

public class ControlCone extends ControlCylinder {

  public ControlCone (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    InteractiveCone cone;
    if (_drawable instanceof InteractiveCone) cone = (InteractiveCone) _drawable;
    else cone = new InteractiveCone();
    cone.setOrigin(0.5,0.5,0,true);
    return cone;
  }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("closedTop"))  return "HIDDEN";
    return super.getPropertyInfo(_property);
  }

} // End of interface