/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveBox;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlBox extends ControlInteractiveTile {
  static final int PROPERTIES_BOX=PROPERTIES_ADDED+2;

  public ControlBox (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    InteractiveBox box;
    if (_drawable instanceof InteractiveBox) box = (InteractiveBox) _drawable;
    else box = new InteractiveBox();
    box.setOrigin(0,0,0,true);
    return box;
  }

// ------------------------------------------------
// Definition of Properties
// ------------------------------------------------

  static java.util.ArrayList infoList=null;

  public java.util.ArrayList getPropertyList() {
    if (infoList==null) {
      infoList = new java.util.ArrayList ();
      infoList.add ("closedBottom");
      infoList.add ("closedTop");
      infoList.addAll(super.getPropertyList());
    }
    return infoList;
  }

  public String getPropertyInfo(String _property) {
    if (_property.equals("closedBottom"))  return "boolean BASIC";
    if (_property.equals("closedTop"))     return "boolean BASIC";
    return super.getPropertyInfo(_property);
  }

  // Backwards compatibility
  public ControlElement setProperty(String _property, String _value) {
    _property = _property.trim();
    if (_property.equals("dx")) return super.setProperty ("sizex",_value);
    if (_property.equals("dy")) return super.setProperty ("sizey",_value);
    if (_property.equals("dz")) return super.setProperty ("sizez",_value);
    if (_property.equals("linecolor")) return super.setProperty ("secondaryColor",_value);
    return super.setProperty(_property,_value);
  }

// ------------------------------------------------
// Set and Get the values of the properties
// ------------------------------------------------

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case  0 : ((InteractiveBox) myElement).setClosedBottom(_value.getBoolean()); break;
      case  1 : ((InteractiveBox) myElement).setClosedTop(_value.getBoolean());    break;
      default: super.setValue(_index-2,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case  0 : ((InteractiveBox) myElement).setClosedBottom(true); break;
      case  1 : ((InteractiveBox) myElement).setClosedTop(true);    break;
      default: super.setDefaultValue(_index-2); break;
    }
  }

  public Value getValue (int _index) {
    switch (_index) {
      case 0 : case 1 : return null;
      default: return getValue (_index-2);
    }
  }


// -------------------------------------
// Respond to interaction
// -------------------------------------

  static private final int[] posSpot = {0+PROPERTIES_BOX,1+PROPERTIES_BOX,2+PROPERTIES_BOX};
  static private final int[] sizeSpot = {3+PROPERTIES_BOX,4+PROPERTIES_BOX,5+PROPERTIES_BOX};

  int[] getPosSpot ()  { return posSpot; }
  int[] getSizeSpot ()  { return sizeSpot; }

} // End of interface