/*
 * The control.displayejs package contains subclasses of
 * control.ControlElement that deal with the displayejs package
 * Copyright (c) October 2003 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */


package org.opensourcephysics.ejs.control.displayejs;

import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlArrow extends ControlInteractiveElement {

  public ControlArrow (Object _visual) { super (_visual); }

  protected Drawable createDrawable (Object _drawable) {
    if (_drawable instanceof InteractiveArrow) return (InteractiveArrow) _drawable;
    else {
      InteractiveArrow arrow = new InteractiveArrow(InteractiveArrow.ARROW);
      arrow.setEnabled(InteractiveElement.TARGET_SIZE,true); // Backwards compatibility
      return arrow;
    }
  }

// ------------------------------------------------
// Properties
// ------------------------------------------------

  public String getPropertyInfo(String _property) {
    if (_property.equals("style"))           return "ArrowStyle|int BASIC";
    if (_property.equals("elementposition")) return "ElementPosition|int BASIC HIDDEN";
    if (_property.equals("angle"))           return "int|double BASIC HIDDEN";
    if (_property.equals("font"))            return "Font|Object  BASIC HIDDEN";
    return super.getPropertyInfo(_property);
  }

  public Value parseConstant (String _propertyType, String _value) {
    if (_value==null) return null;
    if (_propertyType.indexOf("ArrowStyle")>=0) {
      _value = _value.trim().toLowerCase();
      if (_value.equals("arrow"))       return new IntegerValue (InteractiveArrow.ARROW);
      if (_value.equals("segment"))     return new IntegerValue (InteractiveArrow.SEGMENT);
      if (_value.equals("box"))         return new IntegerValue (InteractiveArrow.BOX);
    }
    return super.parseConstant (_propertyType,_value);
  }

  public void setValue (int _index, Value _value) {
    switch (_index) {
      case ENABLED           : myElement.setEnabled(InteractiveElement.TARGET_SIZE,_value.getBoolean()); break;
      case ENABLED_SECONDARY : myElement.setEnabled(InteractiveElement.TARGET_POSITION,_value.getBoolean()); break;
      case STYLE : ((InteractiveArrow) myElement).setArrowType(_value.getInteger()); break;
      default: super.setValue(_index,_value); break;
    }
  }

  public void setDefaultValue (int _index) {
    switch (_index) {
      case ENABLED           : myElement.setEnabled(InteractiveElement.TARGET_SIZE,true); break;
      case ENABLED_SECONDARY : myElement.setEnabled(InteractiveElement.TARGET_POSITION,false); break;
      case STYLE : ((InteractiveArrow) myElement).setArrowType(InteractiveArrow.ARROW); break;
      default: super.setDefaultValue(_index); break;
    }
  }

} // End of class