/**
 * The package contains definitions for the different parts of a simulation
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs;

/**
 * A base interface for the graphical user interface of a simulation
 */

public interface View extends org.opensourcephysics.controls.Control {

 /**
  * Clearing any previous data
  */
  public void reset();

 /**
  * updating all possible data
  */
  public void initialize();

 /**
  * Read current data
  */
  public void read();

 /**
  * Read a single variable
  */
  public void read(String _variable);

 /**
  * Accept data sent
  */
  public void update();

  /**
   * Get a graphical object
   * @param _name A keyword that identifies the graphical object that
   * must be retrieved. Typically its name.
   * @return The graphical component
   */
   public java.awt.Component getComponent (String _name);

} // End of class


