/**
 * The package contains definitions for the different parts of a simulation
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.ejs;

/**
 * A base interface for the model of a simulation
 */

public interface Model {

 /**
  * Sets the simulation in which this model operates
  * @param Simulation _simulation  The simulation that will use this
  * object as model
  */
//  public void setSimulation (Simulation _simulation);

 /**
  * Gets the simulation in which this model runs (if any)
  */
  public Simulation getSimulation ();

 /**
  * Gets the view for this model (if any)
  */
  public View getView ();

 /**
  * Sets the view for this model
  */
//  public void setView (View _aView);

// --------------------------------------------------------
// Model states
// --------------------------------------------------------

  public void reset ();

  public void initialize ();

  public void step ();

  public void update ();

} // End of class


