/*
 * The display package contains drawing classes and drawables
 * Copyright (c) June 2002 F. Esquembre
 * @author F. Esquembre (http://fem.um.es).
 */

package org.opensourcephysics.displayejs;


public class TraceSet extends ElementSet {

  public TraceSet (int _n) { super (_n,InteractiveTrace.class); }

  public InteractiveTrace traceAt (int i) { return (InteractiveTrace) elements[i]; }

  public void clear() {
    for (int i=0; i<numElements; i++) ((InteractiveTrace) elements[i]).clear();
  }

  public void addPoints (double[] _x, double[] _y, double[] _z) {
    int n = numElements;
    if (n>_x.length) n = _x.length;
    if (n>_y.length) n = _y.length;
    if (_z==null) {
      for (int i=0; i<n; i++) ((InteractiveTrace) elements[i]).addPoint(_x[i],_y[i],0.0);
    }
    else {
      if (n>_z.length) n = _z.length;
      for (int i=0; i<n; i++) ((InteractiveTrace) elements[i]).addPoint(_x[i],_y[i],_z[i]);
    }
  }

}
