/*
 * The display3D package contains 3D drawing classes and drawables
 * @author F. Esquembre (http://fem.um.es).
 * Last version : July 2003
 */

package org.opensourcephysics.displayejs;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * A base abstract class for objects that need to implement InteractionSource
 */
public abstract class AbstractInteractionSource implements InteractionSource {

  private ArrayList listeners = new ArrayList();

  public void addListener (InteractionListener _listener) {
    if (_listener==null || listeners.contains(_listener)) return;
    listeners.add(_listener);
  }

  public void removeListener (InteractionListener _listener) { listeners.remove(_listener); }

  public void removeAllListeners () { listeners = new ArrayList(); }

  public void invokeActions (InteractionEvent _event) {
    Iterator  it = listeners.iterator();
    while(it.hasNext()) {
      InteractionListener listener = (InteractionListener) it.next();
      listener.interactionPerformed (_event);
    }
  }

}

